/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CDC.cpp,v 1.2 1999/10/06 06:41:00 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CDC.h"

_USING_PGP

// Class CDC member functions

CDC::CDC(HDC dc) : 

	mDC(dc), mAttribDC(NULL), mHWnd(NULL), mWeCreated(FALSE), 
		mWeArePainting(FALSE), mWeGotFromWindow(FALSE)
{
}

CDC::CDC(HWND hwnd, PGPBoolean includeNCArea) : 

	mDC(NULL), mAttribDC(NULL), mHWnd(NULL), mWeCreated(FALSE), 
		mWeArePainting(FALSE), mWeGotFromWindow(FALSE)
{
	AttachFromWindow(hwnd, includeNCArea);
}

CDC::~CDC()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

CDC& 
CDC::operator=(HDC dc)
{
	Attach(dc);
	return *this;
}

void 
CDC::FillRect(const RECT& rect, HBRUSH brush)
{
	pgpAssert(IsAttached());

	if (::FillRect(DC(), &rect, brush) == 0)
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());
}

void 
CDC::FitStringToWidth(CString& cstr, PGPInt32 maxWidth) const
{
	pgpAssert(IsAttached());

	// Consider each left substring.
	for (PGPUInt32 i = 1; i <= cstr.Length(); i++)
	{
		// Calculate width of string in pixels.
		CString	leftSub;
		cstr.Left(i, leftSub);

		CSize	leftSubRect	= GetTextExtentPoint32(leftSub);
		LPtoDP(leftSubRect);

		// If too large for window, truncate.
		if (leftSubRect.CX() > maxWidth)
		{
			CString	temp;

			if (i > 3)
			{

				cstr.Left(i - 3, temp);
				temp.Append("...");
			}
			else
			{
				CString	temp;
				cstr.Left(i - 1, temp);
			}

			cstr = temp;
			break;
		}
	}
}

CSize 
CDC::GetTextExtentPoint32(const char *str, PGPUInt32 length) const
{
	pgpAssert(IsAttached());
	pgpAssertAddrValid(str, char);

	CSize	size;

	if (!::GetTextExtentPoint32(DC(), str, length, size))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	return size;
}

CSize 
CDC::GetTextExtentPoint32(const char *str) const
{
	pgpAssertStrValid(str);
	pgpAssert(IsAttached());

	return GetTextExtentPoint32(str, strlen(str));
}

void 
CDC::LPtoDP(PPOINT pPoints, PGPUInt32 numPoints) const
{
	pgpAssert(IsAttached());

	if (!::LPtoDP(DC(), pPoints, numPoints))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());
}

void 
CDC::DPtoLP(PPOINT pPoints, PGPUInt32 numPoints) const
{
	pgpAssert(IsAttached());

	if (!::DPtoLP(DC(), pPoints, numPoints))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());
}

HPALETTE 
CDC::SelectPalette(HPALETTE palette, PGPBoolean forceBackground)
{
	pgpAssert(IsAttached());

	HPALETTE	prevPalette	= ::SelectPalette(DC(), palette, forceBackground);

	if (IsNull(prevPalette))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	return prevPalette;
}

PGPUInt32 
CDC::RealizePalette()
{
	pgpAssert(IsAttached());

	PGPUInt32	numEntries	= ::RealizePalette(DC());

	if (numEntries == GDI_ERROR)
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	return numEntries;
}

void 
CDC::CreateCompatible(HDC dc)
{
	Clear();
	mDC = CreateCompatibleDC(dc);

	if (IsNull(mDC))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

void 
CDC::Attach(HDC dc)
{
	if (mDC == dc)
		return;

	Clear();
	mDC = dc;
}

void 
CDC::AttachFromWindow(HWND hwnd, PGPBoolean includeNCArea)
{
	Clear();

	mHWnd = hwnd;

	// 'hwnd' can be NULL, which means the desktop.
	if (IsNull(hwnd) || !includeNCArea)
		mDC = GetDC(hwnd);
	else
		mDC = GetWindowDC(hwnd);

	if (IsNull(mDC))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeGotFromWindow = TRUE;
}

void 
CDC::BeginPaint(HWND window)
{
	Clear();

	mHWnd = window;

	mDC = ::BeginPaint(window, &mPaintStruct);

	if (IsNull(mDC))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeArePainting = TRUE;
}

void 
CDC::Clear()
{
	if (WeGotFromWindow())
		ReleaseDC(Window(), mDC);
	else if (WeArePainting())
		EndPaint(mHWnd, &mPaintStruct);
	else if (WeCreated())
		DeleteDC(mDC);

	mWeGotFromWindow = FALSE;
	mWeCreated = FALSE;
	mWeArePainting = FALSE;
	mDC	= NULL;
	mHWnd = NULL;
}
